#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <unistd.h>

#define N 5//broj vozila-niti
#define null NULL

typedef struct vozilo
{
    int id;
    int tip; //kamion=3,autobus=2,auto=1
    int smer;//0 u desno,1 u levo
    int vremePrilaska;
}vozilo;

int trenutniSmer=-1;//-1 nema niko,0 desno,1 1evo
int brojVozila=0;//zbog kamiona
int brojAutobusa=0;
int brojKamiona=0;

pthread_mutex_t nadvoznjak;
pthread_cond_t guzva;

//int stanjeSmera[2]={0,0}; index 0 kretanje u desno,index 1 kretanje u levo

void *prelaz(void *arg)
{
    vozilo * voz=(vozilo*)arg;
    sleep(voz->vremePrilaska);//vremePrilaska
    pthread_mutex_lock(&nadvoznjak);
    while(voz->smer!=trenutniSmer || trenutniSmer!=-1 ||((voz->tip==2)&&brojAutobusa>0)||((voz->tip==3)&&brojVozila>0)||brojKamiona>0)
    {
        pthread_cond_wait(&guzva,&nadvoznjak);
    }
    if(voz->tip==3)
        brojKamiona++;
    if(voz->tip==2)
        brojAutobusa++;
    trenutniSmer=voz->smer;
    brojVozila++;
    printf("Vozilo tipa %d sa id %d se krece u smeru %d\n",voz->tip,voz->id,voz->smer);
    printf("ovde");
    pthread_mutex_unlock;
    sleep(2);//recimo da 2 sekunde treba vozilu da predje;
    pthread_mutex_lock(&nadvoznjak);
    brojVozila--;
    if(brojVozila==0)
        trenutniSmer=-1;
    if(voz->tip==3)
        brojKamiona--;
    if(voz->tip==2)
        brojAutobusa--;
    pthread_cond_broadcast(&guzva);
    pthread_mutex_unlock(&nadvoznjak);   

    pthread_exit(NULL);
}


int main()
{
    vozilo *vozilo1=malloc(sizeof(vozilo));
    if(!vozilo1)
    {
        printf("greska pri alociranju");
        exit(1);
    }
    pthread_t niti[N];
    srand(time(NULL));
    pthread_mutex_init(&nadvoznjak,NULL);
    pthread_cond_init(&guzva,NULL);

    for(int i=0;i<N;i++)
    {
        vozilo1->id=i;
        vozilo1->tip=1+rand()%3;//1,2,3
        vozilo1->vremePrilaska=1+rand()%3;//1,2,3 sekunde
        vozilo1->smer=rand()%2;//0 u desno,1 u levo
        //printf("%d %d %d\n",vozilo1->tip,vozilo1->vremePrilaska,vozilo1->smer);
        pthread_create(&niti[i],NULL,prelaz,(void *)vozilo1);
    }

    for(int i=0;i<N;i++)
    {
        pthread_join(niti[i],NULL);
    }
    pthread_mutex_destroy(&nadvoznjak);
    pthread_cond_destroy(&guzva);
    return 0;
}